<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0 RC2
// ||              
// ||             .
// ||       (  )
// || tranlated by: arabsdesign.com
// || www.arabsdesign.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'showimage');

$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

$globaltemplates = array(
	'ADV_GALLERY_SHOWIMAGE',
	'adv_gallery_showimage_custombits',
	'adv_gallery_showimage_exifbits',
	'adv_gallery_showimage_keywordbit',
	'im_aim',
	'im_yahoo',
	'im_icq',
	'im_msn',
	'navbar_main',
	'bbcode_quote',
	'postbit',
	'postbit_buttons',
	'postbit_ip',
	'postbit_onlinestatus',
	'postbit_reputation',
	'showthread_quickreply'
);

$phrasegroups = array(
	'adv_gallery_showimg',
	'postbit',
	'showthread',
	'posting'
);

require_once('./gallery_global.php');

globalize($_REQUEST, array('postid' => INT, 'pagenumber' => INT, 'goto' => STR_NOHTML, 'orderby' => STR_NOHTML, 'direction' => STR_NOHTML, 'imageuser' => INT, 'searchid' => INT, 'original' => INT));

if ($postid AND !$imageid)
{
	$getimageid = $DB_site->query_first("SELECT imageid FROM " . TABLE_PREFIX . "adv_gallery_posts WHERE postid = '$postid'");
	$imageid = $getimageid['imageid'];
	exec_header_redirect("showimage.php?$session[sessionurl_js]i=$imageid#post$postid");
}

check_image_id($imageid);

// Get next / previous image
if ($goto == 'next' OR $goto == 'previous')
{
	if ($catid == 'searchresults')
	{
		$search = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_search WHERE searchid = '$searchid'");
		$orderby = $search['orderby'];
		$direction = $search['direction'];
		if (!$search['searchid'])
		{
			eval(print_standard_error('searchnoresults'));
		}
	}
	$doorderby = construct_orderby();

	if ($orderby == 'rating')
	{
		$votequery = 'IF(votenum >= ' . $vboptions['showvotes'] . ', votenum, 0) AS votenum, IF(votenum >= ' . $vboptions['showvotes'] . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
	}

	if ($doorderby == 'title' AND !$direction)
	{
		$direction = 'DESC';
	}

	if ($direction != 'ASC')
	{
		$direction = 'DESC';
	}

	// Figure out which category we're dealing with
	switch ($catid)
	{
		// User Favorites
		case 'favorites':

			$favquery = ' LEFT JOIN ' . TABLE_PREFIX . 'adv_gallery_favorites AS favorites USING (imageid)';
			$imagequery = ' AND favorites.userid = \'' . $bbuserinfo['userid'] . '\' ORDER BY ' . $doorderby . ' ' . $direction;
			break;

		// Popular images
		case 'popimages':
			$imagequery = 'ORDER BY ' . $doorderby . ' DESC LIMIT ' . $vba_options['gallery_popimagelimit'];
			break;

		// New Images
		case 'newimages':
			$imagequery = 'ORDER BY dateline DESC LIMIT ' . $vba_options['gallery_newimagelimit'];
			break;

		// New Posts
		case 'newposts':
			$imagequery = 'AND images.posts != 0 ORDER BY images.lastpostdateline DESC, imageid LIMIT ' . $vba_options['gallery_newimagelimit'];
			break;

		// Member Search
		case 'member':
			$imagequery = ' AND userid = \'' . $imageuser . '\' ORDER BY ' . $doorderby . ' ' . $direction;
			break;

		case 'searchresults':
			$imagequery = ' AND imageid IN (' . $search['imageids'] . ') ORDER BY ' . $doorderby . ' ' . $direction;
			break;

		// Directory ID
		default:
			$cat = intval($catid);

			// In case of a reply, there won't be a catid... Assume we're in a category
			if (!$cat)
			{
				$getcat = $DB_site->query_first("SELECT catid FROM " . TABLE_PREFIX . "adv_gallery_images WHERE imageid = '$imageid'");
				$cat = $getcat['catid'];
			}

			$imagequery = 'AND catid = \'' . $cat . '\' ORDER BY ' . $doorderby . ' ' . $direction;
	}

	$counter = 0;
	$imagearray = array();
	$getids = $DB_site->query("SELECT $votequery images.imageid FROM " . TABLE_PREFIX . "adv_gallery_images AS images $favquery WHERE valid = 1 $imagequery");
	while($prevnext = $DB_site->fetch_array($getids))
	{
		$counter ++;
		$imagearray[] = $prevnext['imageid'];
	}

	$key = array_search($imageid, $imagearray);
	if ($goto == 'next')
	{
		if (isset($imagearray[$key+1]))
		{
			$imageid = $imagearray[$key+1];
		}
		else
		{
			$imageid = $imagearray[0];
		}
	}
	else
	{
		if (isset($imagearray[$key-1]))
		{
			$imageid = $imagearray[$key-1];
		}
		else
		{
			$imageid = $imagearray[$counter-1];
		}
	}
}

if ($bbuserinfo['userid'] AND $vba_options['gallery_allowfav'])
{
	$query['favfields'] = ',NOT ISNULL(favorites.imageid) AS favid';
	$query['favjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'adv_gallery_favorites AS favorites ON (favorites.imageid = images.imageid AND favorites.userid = ' . $bbuserinfo['userid'] . ')';
}

if ($show['subscribe'])
{
	$query['subfields'] = ',NOT ISNULL(subscribeimage.imageid) AS issubscribed';
	$query['subjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'adv_gallery_subscribeimage AS subscribeimage ON (subscribeimage.imageid = images.imageid AND subscribeimage.userid = ' . $bbuserinfo['userid'] . ')';
}

$image = $DB_site->query_first("
		SELECT images.imageid, username, images.userid, images.title, images.catid, dateline, images.description, keywords, filename, width, height, extension, filesize, originalname, originalfilesize, originalwidth, originalheight, views, posts, valid, open, sticky, votenum, votetotal, categories.title AS category, parentlist, options, catuserid, useroptions, customfields.*
		$query[favfields]
		$query[subfields]
		FROM " . TABLE_PREFIX . "adv_gallery_images AS images
		LEFT JOIN " . TABLE_PREFIX ."adv_gallery_categories AS categories ON (images.catid = categories.catid)
		LEFT JOIN " . TABLE_PREFIX . "adv_gallery_customfields_entries AS customfields ON (images.imageid = customfields.imgid)
		$query[favjoin]
		$query[subjoin]
		WHERE images.imageid = '$imageid' AND valid = 1
");

check_image_id($image['imageid']);

$categoryperms = fetch_category_perms($image['catid']);

if (!$categoryperms['canviewimages'])
{
	print_adv_no_permission();
}

if ($image['catuserid'] AND $image['catuserid'] != $bbuserinfo['userid'] AND !is_category_mod($catinfo['parentlist']))
{
	$useroptions = construct_cat_user_opts($image['catid'], $image['useroptions']);
	if (!$useroptions['allow_view'])
	{
		print_adv_no_permission();
	}
}

$catopts = construct_cat_opts($image['catid'], $image['options']);

if ($categoryperms['canrateimages'] AND $catopts['allow_ratings'] AND $vba_options['gallery_allowrating'])
{
	$show['ratelink'] = true;
}

require_once('./includes/functions_bbcodeparse.php');

$show['modopts'] = is_category_mod($image['parentlist']);

$DB_site->query("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "adv_gallery_images SET views = views + 1 WHERE imageid = '$image[imageid]'");

$image['title'] = stripslashes($image['title']);
if (!$image['title'])
{
	$image['title'] = $image['filename'];
}
$image['description'] = parse_bbcode2(stripslashes($image['description']), $catopts['allow_desc_html'], $catopts['allow_desc_bbimgcode'], $catopts['allow_desc_smilies'], $catopts['allow_desc_bbcode']);
$image['views'] = number_format($image['views']);
$image['posts'] = iif(!$categoryperms['canviewreplies'], 0, number_format($image['posts']));
$image['keywords'] = stripslashes($image['keywords']);
$image['dateadded'] = vbdate($vboptions['dateformat'], $image['dateline']);
$image['timeadded'] = vbdate($vboptions['timeformat'], $image['dateline']);
$image['username'] = stripslashes($image['username']);
$image['filesize'] = make_good_size($image['filesize']);
$image['originalfilesize'] = make_good_size($image['originalfilesize']);

$imagecode = construct_image_url($image, iif($original, 'originalname', 'filename'), true);

if ($searchid)
{
	$search = $DB_site->query_first("SELECT string, sfields, wholeword FROM " . TABLE_PREFIX . "adv_gallery_search WHERE searchid = '$searchid'");

	$sfields = explode(',', $search['sfields']);

	if (in_array('description', $sfields))
	{
		$image['description'] = highlight_keywords($image['description'], $search['string'], $search['wholeword']);
	}
}

if ($image['keywords'])
{
	if ($vba_options['gallery_convertkeywords'])
	{
		$kwords = explode(' ', trim($image['keywords']));
		$image['keywords'] = '';
		foreach ($kwords AS $keyword)
		{
			if ($keywords)
			{
				$comma = ',';
			}

			if ($searchid)
			{
				if (in_array('keywords', $sfields))
				{
					$image['keyword'] = highlight_keywords($keyword, $search['string'], $search['wholeword']);
				}
			}

			eval('$image[\'keywords\'] .= "$comma ' . fetch_template('adv_gallery_showimage_keywordbit') . '";');
		}
	}
}
else
{
	$image['keywords'] = $vbphrase['none'];
}

if (substr($image['username'], -1) != 's')
{
	$plurals = $vbphrase['plural_s'];
}

$image['statusicon'] = 'old';

if ($image['dateline'] > $bbuserinfo['lastvisit'])
{
	$image['statusicon'] = 'new';
}

if ($image['votetotal'])
{
	$image['truerating'] = number_format($image['votetotal'] / $image['votenum'], 2);
	$image['roundrating'] = round($image['truerating']);
}
else
{
	$image['truerating'] = 0;
}

$customfields = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_customfields ORDER BY displayorder");
if ($DB_site->num_rows($customfields))
{
	$show['customfields'] = true;
	while ($field = $DB_site->fetch_array($customfields))
	{
		$bgclass = exec_switch_bg();
		$thisfield = 'field' . $field['fieldid'];

		$field['value'] = parse_bbcode2($image["$thisfield"], $catopts['allow_custom_html'], $catopts['allow_custom_bbimgcode'], $catopts['allow_custom_smilies'], $catopts['allow_custom_bbcode']);
		if ($searchid)
		{
			if (in_array($thisfield, $sfields))
			{
				$field['value'] = highlight_keywords($image["$thisfield"], $search['string'], $search['wholeword']);
			}
		}
		eval('$customfieldbits .= "' . fetch_template('adv_gallery_showimage_custombits') . '";');
	}
}
$DB_site->free_result($customfields);
unset($field);

if ($vba_options['gallery_showexif'] AND function_exists('exif_read_data'))
{
	$exif['info'] = @exif_read_data($vba_options['gallery_filedirectory'] . '/' . implode('/', preg_split('//', $image['userid'], -1, PREG_SPLIT_NO_EMPTY)) . '/' . $image['filename'], 'EXIF'); 

	if (!empty($exif['info']))
	{
		$exif['count'] = 0;
		$exif['display'] = array(
			'Make',
			'Model',
			'Orientation',
			'ImageDescription',
			'Model',
			'XResolution',
			'ResolutionUnit',
			'DateTime',
			'ISOSpeedRatings',
			'ExposureBiasValue',
			'MeteringMode',
			'Flash',
			'FlashPixVersion',
			'DigitalZoomRatio',
			'GainControl',
			'Saturation',
			'InterOperabilityIndex',
			'Macro',
			'DigitalZoom',
			'YResolution',
			'Software',
			'YCbCrPositioning',
			'ExposureTime',
			'ExposureProgram',
			'CompressedBitsPerPixel',
			'MaxApertureValue',
			'LightSource',
			'FocalLength'
		);

		$show['camerainfo'] = true;
		foreach ($exif['info'] AS $title => $value)
		{
			if (in_array($title, $exif['display']))
			{
				$exif['count']++;
				eval('$exifrows .= "' . fetch_template('adv_gallery_showimage_exifbits') . '";');

				if ($exif['count'] == 2)
				{
					$exifrows .= '</tr><tr>';
					$exif['count'] = 0;
				}
			}
		}
	}

	unset($exif);
}

$adv_sorturl = construct_adv_sort_url();

if ($vba_options['gallery_allowreplies'] AND $categoryperms['canreplytoimages'] AND $catopts['open_for_posts'] != 0  AND $catopts['allow_replies'])
{
	$show['replylink'] = true;
}

if ($categoryperms['cansendimagetofriend'])
{
	$show['sendtofriend'] = true;
}

if ($bbuserinfo['userid'] AND (($image['userid'] == $bbuserinfo['userid'] AND $categoryperms['caneditimages']) OR $categoryperms['caneditothersimages'] OR is_category_mod($image['parentlist'])))
{
	$show['editlink'] = true;
}

// ######################### Replies to Image #############################
if ($vba_options['gallery_allowreplies'] AND $categoryperms['canviewreplies'] AND $catopts['allow_replies'])
{

	if ($bbuserinfo['maxposts'] != -1)
	{
		$perpage = $bbuserinfo['maxposts'];
	}

	if (!intval($perpage))
	{
		$perpage = $vba_options['gallery_repliesperpage'];
	}

	if ($_REQUEST['p'])
	{
		$postid = intval($_REQUEST['p']);
	}

	if ($postid)
	{
		$pages = $DB_site->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_gallery_posts WHERE postid < '$postid' AND imageid = '$image[imageid]' AND visible = 1");
		$pagenumber = ceil(($pages['count'] + 1) / $perpage);
	}

	if (!intval($pagenumber))
	{
	 	$pagenumber = 1;
	}
	$counter = 0;
	$perpage = intval($perpage);
	$lowerlimit = ($pagenumber-1) * $perpage + 1;
	$upperlimit = ($pagenumber) * $perpage;

	$countreplies = $DB_site->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "adv_gallery_posts WHERE imageid = '$image[imageid]' AND visible = 1");

	if ($countreplies['count'] > 0)
	{
		if ($upperlimit > $countreplies['count'])
		{
			$upperlimit = $countreplies['count'];
			if ($lowerlimit > $countreplies['count'])
			{
				$lowerlimit = $countreplies['count'] - $perpage;
			}
		}
		if ($lowerlimit <= 0)
		{
			$lowerlimit = 1;
		}

		$pagenav = construct_page_nav($countreplies['count'], 'showimage.php?' . $session['sessionurl'] . 'i='. $image['imageid'] . $adv_sort_url);

		$counter = 0;
		$postcount = ($pagenumber - 1 ) * $perpage;
		$show['postheader'] = true;

		if ($vba_options['gallery_showquickreply'] AND $show['replylink'] AND $image['open'])
		{
			$SHOWQUICKREPLY = true;
		}

		require_once('./includes/functions_bigthree.php');
		require_once('./includes/functions_showthread.php');

		// Icons
		if ($vba_options['gallery_allowicons'])
		{
			$query['iconfields'] = ',icon.title as icontitle, icon.iconpath';
			$query['iconjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'icon AS icon ON (posts.iconid = icon.iconid)';
		}

		// Avatars
		if ($vboptions['avatarenabled'])
		{
			$query['avatarfields'] = ',avatar.avatarpath, NOT ISNULL(customavatar.avatardata) AS hascustomavatar, customavatar.dateline AS avatardateline, avatarrevision';
			$query['avatarjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'avatar AS avatar ON (avatar.avatarid = user.avatarid)
				LEFT JOIN ' . TABLE_PREFIX . 'customavatar AS customavatar ON (customavatar.userid = user.userid)';
		}

		// Reputation
		if ($vboptions['reputationenable'])
		{
			$query['repfields'] = ', level';
			$query['repjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'reputationlevel AS reputationlevel ON (user.reputationlevelid = reputationlevel.reputationlevelid)';
		}

		if ($vba_options['gallery_allowsignatures'])
		{
			$query['sigfields'] = ', usertextfield.signature';
			$query['sigjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'usertextfield AS usertextfield ON (usertextfield.userid = posts.userid)';
		}

		$postcount = ($pagenumber - 1) * $perpage;

		$posts = $DB_site->query("
				SELECT posts.postid, posts.pagetext, posts.title, posts.userid, posts.username AS postusername, posts.dateline, posts.ipaddress AS ip, posts.iconid, posts.allowsmilie, posts.showsignature, user.*, userfield.* $query[iconfields] $query[avatarfields] $query[repfields] $query[sigfields]
				FROM " . TABLE_PREFIX . "adv_gallery_posts AS posts
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (posts.userid = user.userid)
				LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (posts.userid = userfield.userid)
				$query[avatarjoin]
				$query[iconjoin]
				$query[repjoin]
				$query[sigjoin]
				WHERE imageid = '$image[imageid]' AND posts.visible = 1
				ORDER BY posts.dateline
				LIMIT " . ($lowerlimit - 1) . ", $perpage
		");
		while ($post = $DB_site->fetch_array($posts))
		{
	    $post['message'] = parse_bbcode2($post['pagetext'], 0, 1, $post['allowsmilie'], 1);
	    $post['postdate'] = vbdate($vboptions['dateformat'], $post['dateline']);
	    $post['posttime'] = vbdate($vboptions['timeformat'], $post['dateline']);
			$post['title'] = stripslashes($post['title']);

			if (empty($checkperms["$post[userid]"]))
			{
				$checkperms["$post[userid]"] = cache_permissions($post, false);
			}

			if ($searchid)
			{
				if (in_array('pagetext', $sfields))
				{
					$post['message'] = highlight_keywords($post['message'], $search['string'], $search['wholeword']);
				}
			}

			$show['postcount'] = true;
			$post['postcount'] = ++$postcount;

			// Status Icon
			$post['statusicon'] = 'old';
			if ($post['dateline'] > $bbuserinfo['lastvisit'])
			{
				$post['statusicon'] = 'new';
			}

			$show['messageicon'] = false;

			// Post Icon
			if ($vba_options['gallery_allowicons'])
			{
				if ($post['iconid'] OR $vboptions['showdeficon'])
				{
					$show['messageicon'] = true;
				}
				if ($vboptions['showdeficon'] AND !$post['iconid'])
				{
					$post['iconpath'] = $vboptions['showdeficon'];
					$post['icontitle'] = $vbphrase['default'];
				}
			}

			// Set default $show variables
			$show['profile'] = false;
			$show['avatar'] = false;
			$show['buddy'] = false;
			$show['search'] = false;
			$show['emaillink'] = false;
			$show['pmlink'] = false;
			$show['homepage'] = false;
			$show['reputation'] = false;

			if ($show['replylink'] AND $image['open'])
			{
				$post['replylink'] = 'newreply.php?' . $session['sessionhash'] . 'p=' . $post['postid'];
			}

			// Show IP address
			$post['iplogged'] = '';
			if ($post['ip'])
			{
				if ($vboptions['logip'] == 2)
				{
					$show['ip'] = true;
					eval('$post[\'iplogged\'] .= "' . fetch_template('postbit_ip') . '";');
				}
				else if ($vboptions['logip'] == 1 AND is_category_mod($post['catid']))
				{
					$show['ip'] = false;
					eval('$post[\'iplogged\'] .= "' . fetch_template('postbit_ip') . '";');
				}
			}

			if ($post['userid'])
			{
				// Post was by a user
				$post = array_merge($post, convert_bits_to_array($post['options'], $_USEROPTIONS));

				$post['musername'] = fetch_musername($post);

				$show['profile'] = true;
				$show['buddy'] = true;
				$show['search'] = true;

				// Email, homepage, & PM links
				if ($post['showemail'] AND $vboptions['displayemails'])
				{
					$show['emaillink'] = true;
				}
				if ($post['homepage'] AND $post['homepage'] != 'http://')
				{
					$show['homepage'] = true;
				}
				if ($vboptions['enablepms'] AND $post['receivepm'])
				{
					$show['pmlink'] = true;
				}

				// Report link
				$show['reportlink'] = false;
				if ($bbuserinfo['userid'] != $post['userid'])
				{
					$show['reportlink'] = true;
				}

				// User stats
		    $post['joindate'] = vbdate($vboptions['registereddateformat'], $post['joindate']);
				$post['posts'] = number_format($post['posts']);

				// Online Status
				fetch_online_status($post, true);

				// Reputation
				if ($vboptions['reputationenable'])
				{
					fetch_reputation_image($post, $checkperms);
					$show['reputation'] = true;
				}

				// Im Icons
				construct_im_icons($post);

				// User Title
				if ($post['customtitle'] == '2')
				{
					$post['usertitle'] = htmlspecialchars_uni($post['usertitle']);
				}

				// Signature
				if ($vboptions['allowsignatures'] AND $post['showsignature'] AND $post['signature'] AND ($bbuserinfo['showsignatures'] OR !$bbuserinfo['userid']))
				{
					$post['signature'] = parse_bbcode($post['signature'], 0, $vboptions['allowsmilies']);
				}
				else
				{
					$post['signature'] = '';
				}

				// Get Avatar
				$show['avatar'] = false;
				$avatarurl = '';
				if ($bbuserinfo['showavatars'] OR !$bbuserinfo['userid'])
				{
			  	if ($post['avatarpath'])
			  	{
				    $avatarurl = $vboptions['bburl'] . '/' . $post['avatarpath'];
			    }
					else if ($post['hascustomavatar'])
					{
						if ($vboptions['usefileavatar'])
						{
							$avatarurl = $vboptions['bburl'] . '/' . $vboptions['avatarurl'] . '/avatar' . $post['userid'] . '_' . $post['avatarrevision'] . '.gif';
						}
						else
						{
							$avatarurl = $vboptions['bburl'] . '/image.php?' . $session['sessionurl'] . 'u=' . $post['userid'] . '&amp;dateline=' . $post['avatardateline'];
						}
					}
					if (!empty($avatarurl))
					{
						$show['avatar'] = true;
					}
				}
				if (($categoryperms['caneditposts'] AND $post['userid'] == $bbuserinfo['userid']) OR $categoryperms['caneditothersposts'])
				{
					$post['editlink'] = 'newreply.php?' . $session['sessionurl'] . 'do=editpost&amp;p=' . $post['postid'];
				}
			}
			else
			{
				// Guest Post
				$post['posts'] = 'n/a';
				$post['username'] = $post['postusername'];
				$post['musername'] = fetch_musername($post);
				$post['usertitle'] = $vbphrase['guest'];
			}

			// Print the postbit
			eval('$postbits = "' . fetch_template('postbit') . '";');

			// Replace links and add $bburl
			$postbit .= str_replace(
				array(
					'"editpost.php',
					'"image.php',
					'imwindow',
					'"member.php',
					'"private.php',
					'"profile.php',
					'"report.php?',
					'"search.php',
					'"showpost.php?p=' . $post['postid'] . '&amp;postcount=' . $post['postcount'],
					'"postings.php'
				),
				array(
					'"newreply.php',
					'"' . $vboptions['bburl'] . '/image.php',
					'openimwindow',
					'"' . $vboptions['bburl'] . '/member.php',
					'"' . $vboptions['bburl'] . '/private.php',
					'"' . $vboptions['bburl'] . '/profile.php',
					'"misc.php?do=report&amp;type=post&amp;',
					'"' . $vboptions['bburl'] . '/search.php',
					'"showimage.php?i=' . $image['imageid'] . '&amp;p=' . $post['postid'] . '#post' . $post['postid'],
					'"misc.php'
				),
				$postbits);

		}
		unset($query);
	}
}

if ($vba_options['gallery_showquickreply'] AND $show['replylink'] AND $bbuserinfo['userid'])
{
	require_once('./includes/functions_editor.php');

	$WYSIWYG = is_wysiwyg_compatible();
	$istyles_js = construct_editor_styles_js();
	$threadedmode = 0;
	$qrpostid = 'who cares';
	$QRrequireclick = 0;
	$onload .= ' editInit();';

	$headinclude .= '
		<!-- set up CSS for the editor -->
		<link rel="stylesheet" type="text/css" href="' . $vboptions['bburl'] . '/clientscript/vbulletin_editor.css" />
		<style type="text/css">
		<!--
		#vBulletin_editor {
			background: ' . $istyles['pi_button_normal'][0] . ';
			padding: ' . $stylevar['cellpadding'] . 'px;
		}
		#controlbar, .controlbar {
			background: ' . $istyles['pi_button_normal'][0] . ';
		}
		.imagebutton {
			background: ' . $istyles['pi_button_normal'][0] . ';
			color: ' . $istyles['pi_button_normal'][1] . ';
			padding: ' . $istyles['pi_button_normal'][2] . ';
			border: ' . $istyles['pi_button_normal'][3] . ';
		}
		-->
		</style>
	';

	unset($threadid);

	if (!$vba_options['gallery_allowsignatures'])
	{
		$bbuserinfo['signature'] = '';
	}

	eval('$quickreply = "' . fetch_template('showthread_quickreply') . '";');

	$quickreply = str_replace(
		array(
			'"postreply"',
			'name="t" value=""',
			'"clientscript'
		),
		array(
			'"doreply"',
			'name="catid" value="' . $image['catid'] . '" /> <input type="hidden" name="imageid" value="' . $image['imageid'] . '"',
			'"' . $vboptions['bburl'] . '/clientscript'
		),
	 $quickreply);
}

if (!intval($catid))
{
	foreach (array_reverse(explode(',', $image['parentlist'])) AS $cid)
	{
		$catnavbits .= iif($ccount, '&gt;') . ' <a href="browseimages.php?' . $session['sessionurl'] . 'c=' . $cid . '">' . $categorycache["$cid"]['title'] . '</a> ';

		$ccount++;
	}
}

switch($catid)
{
	case 'favorites':
		$navbits["browseimages.php?$session[sessionurl]do=favorites"] = $vbphrase['my_favorites'];
		break;

	case 'newimages':
		$navbits["browseimages.php?$session[sessionurl]do=newimages"] = $vbphrase['whats_new'];
		break;

	case 'popimages':
		$navbits["browseimages.php?$session[sessionurl]do=popimages"] = $vbphrase['whats_popular'];
		break;

	case 'searchresults':
		$navbits["$vba_options[gallery_url]/search.php?$session[sessionurl]do=searchresults&amp;searchid=$searchid"] = $vbphrase['search_results'];
		break;

	case 'member':
		$navbits["browseimages.php?$session[sessionurl]do=member&amp;imageuser=$image[userid]"] = construct_phrase($vbphrase['usernames_images'], $image['username'], $plurals);
		break;

	default:
		$navbits = construct_dir_navbits($image['parentlist']);
}

$navbits[''] = $image['title'];
$navbar = construct_adv_navbar($navbits);

eval('print_output("' . fetch_template('ADV_GALLERY_SHOWIMAGE') . '");');

?>